package com.hero.ui.dialog;

import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import com.hero.HeroDesigner;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class ListDialog extends GenericDialog {

	private static final long serialVersionUID = -1006747877148119505L;

	public ListDialog(com.hero.objects.List list, boolean isNew) {
		super(list, isNew, false);
		if (isNew) {
			setTitle("New List");
		} else {
			setTitle(list.getAlias());
		}
		init();
		displayLbl.setText("List Name:");
		if (isNew) {
			okBtn.setEnabled(false);
		}
	}

	@Override
	protected JPanel getTopPanel() {
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 10;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.insets = new Insets(2, 5, 5, 2);
		gbc.anchor = GridBagConstraints.WEST;
		gbc.gridwidth = 3;
		gbc.weightx = 0;
		equipmentPanel.add(carriedCB, gbc);
		gbc.gridy++;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.gridwidth = 1;
		equipmentPanel.add(weightLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 0;
		equipmentPanel.add(weightTF, gbc);
		gbc.gridx = 2;
		gbc.weightx = 1;
		equipmentPanel.add(new JLabel(HeroDesigner.getInstance().getPrefs()
				.isMetric() ? "kg" : "lbs"), gbc);
		gbc.gridy++;
		gbc.gridx = 0;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.weightx = 0;
		equipmentPanel.add(priceLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		if (HeroDesigner.getActiveHero().getRules().isEquipmentUnitsPrefix()) {
			gbc.gridwidth = 2;
			gbc.weightx = 1;
			gbc.anchor = GridBagConstraints.WEST;
			gbc.insets = new Insets(2, 0, 5, 2);
			JPanel pricePanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
			pricePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
			pricePanel.add(new JLabel(HeroDesigner.getActiveHero().getRules()
					.getEquipmentCostUnits()));
			pricePanel.add(priceTF);
			equipmentPanel.add(pricePanel, gbc);
			gbc.insets = new Insets(2, 5, 5, 2);
		} else {
			gbc.gridwidth = 2;
			gbc.weightx = 1;
			gbc.anchor = GridBagConstraints.WEST;
			gbc.insets = new Insets(2, 0, 5, 2);
			JPanel pricePanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
			pricePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
			pricePanel.add(priceTF);
			pricePanel.add(new JLabel(HeroDesigner.getActiveHero().getRules()
					.getEquipmentCostUnits()));
			equipmentPanel.add(pricePanel, gbc);
			gbc.insets = new Insets(2, 5, 5, 2);
		}
		equipmentPanel.setBorder(BorderFactory
				.createTitledBorder("Equipment Info."));

		gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 20;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.insets = new Insets(2, 5, 5, 2);
		JPanel panel = new JPanel(new GridBagLayout());
		panel.add(displayLbl, gbc);
		gbc.gridy = 20;
		gbc.gridx = 1;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 1;
		gbc.gridwidth = 2;
		panel.add(displayTF, gbc);
		gbc.gridy = 99;
		gbc.gridx = 0;
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		if (object.isEquipment()) {
			panel.add(equipmentPanel, gbc);
		}

		return panel;
	}

	@Override
	protected void initListeners() {
		super.initListeners();
		displayTF.getDocument().addDocumentListener(new DocumentListener() {
			public void changedUpdate(DocumentEvent e) {
				okBtn.setEnabled(displayTF.getText().trim().length() > 0);
			}

			public void insertUpdate(DocumentEvent e) {
				okBtn.setEnabled(displayTF.getText().trim().length() > 0);
			}

			public void removeUpdate(DocumentEvent e) {
				okBtn.setEnabled(displayTF.getText().trim().length() > 0);
			}
		});
	}

	@Override
	protected void initWidgets() {
		super.initWidgets();
		addModifierBtn.setText("Add Common Modifier...");
	}

	@Override
	protected void layoutComponent() {
		layoutExtrasPanel();
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.weightx = 1;
		gbc.weighty = 0;
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.insets = new Insets(0, 0, 0, 0);
		extrasPanel.add(adderPanel, gbc);
		gbc.gridy++;
		extrasPanel.add(privateAdderPanel, gbc);
		gbc.gridy++;
		extrasPanel.add(customAdderPanel, gbc);
		gbc.gridy++;
		gbc.weighty = 1;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		extrasPanel.add(modifierPanel, gbc);
		gbc.gridy = 0;
		gbc.weighty = 0;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.insets = new Insets(5, 5, 5, 5);
		JPanel panel = new JPanel(new GridBagLayout());
		panel.add(getTopPanel(), gbc);
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.NONE;
		gbc.gridwidth = 2;
		gbc.gridy++;
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.CENTER;
		gbc.gridx = 2;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.gridy++;
		gbc.gridx = 0;
		gbc.weighty = 1;
		gbc.weightx = 1;
		gbc.fill = GridBagConstraints.BOTH;
		panel.add(extrasScroll, gbc);
		gbc.gridy++;
		gbc.weighty = 0;
		gbc.weightx = 0;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.NORTH;
		JPanel mods = new JPanel(new FlowLayout(FlowLayout.CENTER));
		mods.add(customAdderBtn);
		mods.add(privateAdderBtn);
		mods.add(addModifierBtn);
		panel.add(mods, gbc);
		gbc.gridy++;
		gbc.anchor = GridBagConstraints.SOUTH;
		gbc.gridy++;
		JPanel buttons = new JPanel(new FlowLayout(FlowLayout.CENTER));
		buttons.add(notesBtn);
		buttons.add(multiplierBtn);
		buttons.add(okBtn);
		buttons.add(deleteBtn);
		buttons.add(cancelBtn);
		buttons.add(defineBtn);
		panel.add(buttons, gbc);

		setContentPane(panel);
	}
}